<?php
header('Content-type: text/css');

$_ENV['PROTOCOL'] = (!empty($_SERVER['HTTPS']) ? 'https' : 'http');

$_ENV['BASE_URL'] = getenv('BASE_URL');
if (!isset($_ENV['BASE_URL']) || !($_ENV['BASE_URL'])) {
    $_ENV['BASE_URL'] = (isset($_GET['urlpre']) ? $_GET['urlpre'] : '').basename(substr($_SERVER['REQUEST_URI'], 0, strcspn($_SERVER['REQUEST_URI'], '?')));
}

$fontFamily = explode(',', 'Open Sans')[0];
$fontURL = '../phpwidgets/fonts.php?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic';
if (isset($_GET['family'])) {
    $fontURL = str_replace($fontFamily, explode(',', $_GET['family'])[0], $fontURL);
    $fontFamily = $_GET['family'];
}

if (!isset($_GET['url'])) {
    $_GET['url'] = str_replace(' ', '+', $fontURL.'&display=swap');
}
if (!isset($_GET['url'])) {
    die('Error: must provide url...');
}

$url = $_GET['url'];
if (substr($url, 0, 2) === '//') {
    $url = $_ENV['PROTOCOL'].':'.$url;
}

if (is_dir('./cache') && filemtime(__FILE__) > filemtime('./cache')) {
    rrmdir('./cache');
}
if (!is_dir('./cache')) {
    mkdir('./cache');
}

$url = base64_encode($url.(isset($_GET['urlprefix']) ? '&urlprefix='.$_GET['urlprefix'] : ''));

getFile($url);

function getFile($url)
{
    $filename = md5($url) . '.cache';
    if (!file_exists('./cache/' . $filename)) {
        cacheFile($url, './cache/' . $filename);
    }

    echo file_get_contents('./cache/' . $filename);
}

function cacheFile($url, $filepath) {
    $url = base64_decode($url);
    $content = file_get_contents($url);
    if (strlen($content) > 0) {
        $content = str_replace($_ENV['PROTOCOL'].'://', $_ENV['BASE_URL'].'?url='.$_ENV['PROTOCOL'].'://', $content);
        file_put_contents($filepath, $content);
    }
}

function rrmdir($src) {
    if (file_exists($src)) {
        $dir = opendir($src);
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                $full = $src . '/' . $file;
                if (is_dir($full)) {
                    rrmdir($full);
                } else {
                    unlink($full);
                }
            }
        }
        closedir($dir);
        rmdir($src);
    }
}
